/* ============ */
/* rands55.c	*/
/* ============ */
#include "defcodes.h"
/* ==================================================== */
/* rands55 - Returns Uniform Random Variate in ( 0, 1 )	*/
/* ==================================================== */
#define MBIG	1000000000		/* from Numerical Recipes    */
#undef	MBIG
#define MBIG	(1073741824/2)		/* 2^29                      */
#define MSEED	161803398		/* from Numerical Recipes    */

/* The theory behind this 'subtractive' generator can be found in
 * Knuth, Donald E. 1981, Seminumerical Algorithms, 2nd ed., vol. 2 of
 * The Art of Computer Programming (Reading, Mass.: Addison-Wesley),
 * paragraphs 3.2 & 3.3.
 */

#define mod( a, b )	( a ) % ( b )

/* ===================================================================== */
/* Lrand55 - Returns Uniform Random Long Integer Variate in [0,2^29)	 */
/* ===================================================================== */
long
Lrand55(restart)
long	*restart;			/* if non-zero, reinitializes	*/
{
    static long ma[55];			/* must be 55, see Knuth	*/
    static int start = TRUE;
    static int inext, inextp;

    int     i, ii;
    long    mj, mk;

    if (start || *restart)
    {					/* initialize last element	*/
	mj = mod(MSEED - labs(*restart), MBIG);

	ma[54] = mj;

	mk = 1;
	/* initialize remainder of table */
	for (i = 1; i < 55; i++)
	{
	    ii = mod(21 * i, 55) - 1;
	    ma[ii] = mk;

	    if ((mk = mj - mk) < 0)
		mk += MBIG;

	    mj = ma[ii];
	}
	/* 'warm up' the generator	*/
	for (ii = 0; ii < 3; ii++)
	{
	    for (i = 0; i < 55; i++)
	    {
		if ((ma[i] -= ma[mod(i + 31, 55)]) < 0)
		{
		    ma[i] += MBIG;
		}
	    }
	}
	start = FALSE;
	*restart = FALSE;

	inext = 0;
	inextp = 31;			/* 31=55-24, 24 & 55 from Knuth	*/
    }

    if (++inext >= 55)
    {
	inext = 0;
    }
    if (++inextp >= 55)
    {
	inextp = 0;
    }
    if ((ma[inext] -= ma[inextp]) < 0)
    {
	ma[inext] += MBIG;
    }
    return(ma[inext]);
}
/* ================================================================ */
/* Irand55 - Returns Uniform Random Integer Variate in [0,RAND_MAX] */
/* ================================================================ */
int
Irand55(restart)
long	*restart;
{
    return ((int)(Lrand55(restart) >> 14) & RAND_MAX);
}
/* ================================================================== */
/* Drand55 - Returns Uniform Random Double Precision Variate in [0,1) */
/* ================================================================== */
double
Drand55(restart)
long	*restart;			/* if non-zero, reinitializes	*/
{
    return(Lrand55(restart) / (double) MBIG);
}
